<!DOCTYPE html>
<html>

<head>
    <title>PHP - Integralberechnung</title>
    <meta charset="utf-8">
    <style>
        td, th {
            padding: 4px;
            border: 1px solid lightgray;
        }
    </style>
</head>

<body>
    <h1>Quadratische Funktion f(x)=x<sup>2</sup></h1>

    <?php

    //### Funktionsdefinition ###

    function flaecheParabel($anzahl, $randRechts)
    {

        $gesamtflaeche = 0;                               //Gesamtfläche (anfänglich 0)

        $breite = $randRechts / $anzahl;                            //Breite der Rechtecke (ergibt sich aus "Intervall / Anzahl der Rechtecke")

        $x = $breite;                                     //Stelle des rechten Randes des ersten Rechtecks  (entspricht der Breite eines Rechtecks)

        while ($x <= $randRechts) {                                 //Der Schleifenrumpf wird solange ausgeführt, solange die rechte Grenze des Intervalls nicht überschritten wird

            $hoehe = $x * $x;                             //Berechnung der Höhe des Rechtecks (entspricht dem Funktionswert an der Stelle x, also f(x)=x*x)
            $flaeche = $breite * $hoehe;                  //Teilfläche = Breite x Höhe
            $gesamtflaeche = $gesamtflaeche + $flaeche;   //Teilfläche zur Gesamtfläche addieren

            /*
            echo "Stelle: $x <br>";                       //Stelle ausgeben
            echo "Breite: $breite<br>";                   //Breite ausgeben
            echo "Höhe (Funktionswert): $hoehe<br>";      //Höhe ausgeben (Funktionswert)
            echo "Teilfläche: $flaeche <hr>";             //Teilfläche ausgeben
            */

            $x = $x + $breite;                            //Stelle eins nach rechts verschieben (-> nächstes Rechteck)
        }

        return $gesamtflaeche;                           //Gesamtfläche zurückgeben
    }

    ?>

    <table>
    <tr>
            <th>Anzahl Rechtecke</th>
            <th>Obersumme [0;1]</th>
            <th>Obersumme [0;2]</th>
        </tr>
        <tr>
            <td>4</td>
            <td><?php echo flaecheParabel(4, 1) ?></td>
            <td><?php echo flaecheParabel(4, 2) ?></td>
        </tr>
        <tr>
            <td>6</td>
            <td><?php echo flaecheParabel(6, 1) ?></td>
            <td><?php echo flaecheParabel(6, 2) ?></td>
        </tr>
        <tr>
            <td>10</td>
            <td><?php echo flaecheParabel(10, 1) ?></td>
            <td><?php echo flaecheParabel(10, 2) ?></td>
        </tr>
        <tr>
            <td>50</td>
            <td><?php echo flaecheParabel(50, 1) ?></td>
            <td><?php echo flaecheParabel(50, 2) ?></td>
        </tr>
        <tr>
            <td>100</td>
            <td><?php echo flaecheParabel(100, 1) ?></td>
            <td><?php echo flaecheParabel(100, 2) ?></td>
        </tr>
        <tr>
            <td>1000</td>
            <td><?php echo flaecheParabel(1000, 1) ?></td>
            <td><?php echo flaecheParabel(1000, 2) ?></td>
        </tr>
        <tr>
            <td>10000</td>
            <td><?php echo flaecheParabel(10000, 1) ?></td>
            <td><?php echo flaecheParabel(10000, 2) ?></td>
        </tr>
    </table>


</body>

</html>